/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.skull;

import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import io.github.fabricators_of_create.porting_lib.item.PiglinsNeutralItem;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_5819;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.item.ModifiableArmorItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ChrysophiliteModifier
extends NoLevelsModifier {
    public static final TinkerDataCapability.ComputableDataKey<TotalGold> TOTAL_GOLD = TConstruct.createKey("chrysophilite", TotalGold::new);

    public ChrysophiliteModifier() {
        LivingEntityEvents.DROPS.register(ChrysophiliteModifier::onLivingDrops);
    }

    @Override
    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
        if (context.getChangedSlot() == class_1304.field_6169) {
            context.getTinkerData().ifPresent(data -> {
                TotalGold gold = data.get(TOTAL_GOLD);
                if (gold == null) {
                    ((TotalGold)data.computeIfAbsent(TOTAL_GOLD)).initialize(context);
                } else {
                    gold.setGold(class_1304.field_6169, tool.getVolatileData().getBoolean(ModifiableArmorItem.PIGLIN_NEUTRAL));
                }
            });
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        IToolStackView newTool;
        if (context.getChangedSlot() == class_1304.field_6169 && ((newTool = context.getReplacementTool()) == null || newTool.getModifierLevel(this) == 0)) {
            context.getTinkerData().ifPresent(data -> data.remove(TOTAL_GOLD));
        }
    }

    @Override
    public void onEquipmentChange(IToolStackView tool, int level, EquipmentChangeContext context, class_1304 slotType) {
        class_1304 changed = context.getChangedSlot();
        if (slotType == class_1304.field_6169 && changed.method_5925() == class_1304.class_1305.field_6178) {
            boolean hasGold = ChrysophiliteModifier.hasGold(context, changed);
            context.getTinkerData().ifPresent(data -> ((TotalGold)data.computeIfAbsent(TOTAL_GOLD)).setGold(changed, hasGold));
        }
    }

    public static boolean hasGold(EquipmentChangeContext context, class_1304 slotType) {
        PiglinsNeutralItem piglinsNeutralItem;
        IToolStackView tool = context.getToolInSlot(slotType);
        if (tool != null) {
            return tool.getVolatileData().getBoolean(ModifiableArmorItem.PIGLIN_NEUTRAL);
        }
        class_1309 living = context.getEntity();
        class_1792 class_17922 = living.method_6118(slotType).method_7909();
        return class_17922 instanceof PiglinsNeutralItem && (piglinsNeutralItem = (PiglinsNeutralItem)class_17922).makesPiglinsNeutral(living.method_6118(slotType), living);
    }

    public static int getTotalGold(@Nullable class_1297 entity) {
        return Optional.ofNullable(entity).flatMap(e -> TinkerDataCapability.CAPABILITY.maybeGet(e)).map(data -> data.get(TOTAL_GOLD)).map(TotalGold::getTotalGold).orElse(0);
    }

    private static boolean onLivingDrops(class_1309 target, class_1282 source, Collection<class_1542> drops, int lootingLevel, boolean recentlyHit) {
        int gold;
        if (source != null && (gold = ChrysophiliteModifier.getTotalGold(source.method_5529())) > 0) {
            float extraChance = 0.04f * (float)gold;
            for (class_1304 slot : class_1304.values()) {
                PiglinsNeutralItem piglinsNeutralItem;
                class_1792 class_17922;
                class_1799 stack = target.method_6118(slot);
                class_5819 random = target.method_6051();
                if (stack.method_7960() || class_1890.method_8221((class_1799)stack) || !((class_17922 = stack.method_7909()) instanceof PiglinsNeutralItem) || !(piglinsNeutralItem = (PiglinsNeutralItem)class_17922).makesPiglinsNeutral(stack, target) || !(random.method_43057() < extraChance)) continue;
                if (stack.method_7963()) {
                    stack.method_7974(stack.method_7936() - random.method_43048(1 + random.method_43048(Math.max(stack.method_7936() - 3, 1))));
                }
                drops.add(target.method_5775(stack));
                target.method_5673(slot, class_1799.field_8037);
            }
        }
        return false;
    }

    public static class TotalGold {
        private final boolean[] hasGold = new boolean[4];
        private int totalGold = 0;

        protected boolean setGold(class_1304 slotType, boolean value) {
            int index;
            if (slotType.method_5925() == class_1304.class_1305.field_6178 && this.hasGold[index = slotType.method_5927()] != value) {
                this.hasGold[index] = value;
                this.totalGold = value ? ++this.totalGold : --this.totalGold;
                return true;
            }
            return false;
        }

        public void initialize(EquipmentChangeContext context) {
            this.totalGold = 1;
            for (class_1304 slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                boolean gold;
                this.hasGold[slotType.method_5927()] = gold = ChrysophiliteModifier.hasGold(context, slotType);
                if (!gold) continue;
                ++this.totalGold;
            }
        }

        public int getTotalGold() {
            return this.totalGold;
        }
    }
}

